#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//pulsing universe - testMod01.fsh   by   FabriceNeyret2   
//https://www.shadertoy.com/view/4sXGzX
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// advected texture: stationary deformations
// Fabrice NEYRET  18/07/2013

#define a 1. // angular velocity
#define D 6. // texture regeneration delay

#define Pi 3.1415927
#define cos01(t) (.5-.5*cos(t))
float time;
vec2 FragCoord;

vec3 display_layer(float t)
{
	vec2 uv = (FragCoord.xy / iResolution.y-vec2(.9,.5))*2.;

	// global fade-in and out of effects.
	float T = cos01(2.*Pi*.02*time);
	float phaseT = (mod(.02*time,2.)<1.)? 0. : Pi;
		
	// weight of this layer: appears and disappear seemlessly
	float k = cos01(2.*Pi*t/D);

	// radial effect on angular velocity
	float r = length(uv);
	//r = 1./r;
    r = .1+.4*cos01(r);
	if (phaseT>0.)
		r += T*(30.*exp(-400.*r*r)-.4*cos01(r));
	
	// zoom effect on angular velocity
	float z = 1.-T*cos01(phaseT+Pi*t/D);
	
	// transformation of the texture
    float c = cos(a*t*r), s = sin(a*t*r);
	mat2 M = mat2( c, -s, s, c);
	uv = z*M*uv;
	
	return k*texture2D(texture0,uv).rgb;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec3 col;
    float t= time = iTime+0.3/.02;
	FragCoord=fragCoord;
    
	t = mod(t,D/3.);

	col  = display_layer(t);
    col += display_layer(t+D/3.);
    col += display_layer(t+2.*D/3.);
	
	
	fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

